package examples.session.stateless;

import javax.naming.Context;
import javax.naming.InitialContext;
import java.util.Hashtable;

// The following import should be removed.

import examples.session.stateless.*;
import javax.naming.*;

/**
 * This class is an example of client code which invokes
 * methods on a simple, remote stateless session bean.
 */
public class HelloClient {

	public static void main(String[] args) throws Exception {
		/*
		 * Obtain the JNDI initial context.
		 *
		 * The initial context is a starting point for
		 * connecting to a JNDI tree. We choose our JNDI
		 * driver, the network location of the server, etc
		 * by passing in the environment properties.
		 */

		System.out.println("about to create initialcontext");

                Hashtable env = new Hashtable();
		env.put("java.naming.factory.initial","com.sun.enterprise.naming.SerialInitContextFactory");
		env.put("java.naming.factory.url.pkgs","com.sun.enterprise.naming");
		env.put("java.naming.provider.url","localhost:3700");
		Context ctx = new InitialContext();

		//System.out.println ("Trying to get the name of this context: " + ctx.getNameInNamespace());

		System.out.println("Got initial context ... yeah ");

		/*
		 * Get a reference to a bean instance, looked up by class name
		 */
		NamingEnumeration ne = ctx.list("");
		System.out.println("Got list... ");
                while(ne.hasMore())
		{
                        NameClassPair nc = (NameClassPair)ne.next();
			System.out.println("Entry is ... "+nc.getName()+" -- "+nc.getClassName());
		}

		Hello hello = (Hello) ctx.lookup("examples.session.stateless.Hello");

		/*
		 * Call the hello() method on the bean.
		 * We then print the result to the screen.
		 */
		System.out.println(hello.hello());
	}
}
